/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.XAReturnValue;
import com.microsoft.sqlserver.jdbc.XidImpl;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class SQLServerXAResource
implements XAResource {
    private SQLServerConnection con;
    private int timeoutSeconds;
    private static final int XA_START = 0;
    private static final int XA_END = 1;
    private static final int XA_PREPARE = 2;
    private static final int XA_COMMIT = 3;
    private static final int XA_ROLLBACK = 4;
    private static final int XA_FORGET = 5;
    private static final int XA_RECOVER = 6;
    private SQLServerConnection controlConnection;
    private static boolean xaInitDone;
    private static Integer xaInitLock;
    private String sResourceManagerId;
    private int enlistedTransactionCount;
    private Logger xaLogger = SQLServerXADataSource.xaLogger;

    SQLServerXAResource(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        Properties properties = sQLServerConnection.activeConnectionProperties;
        this.sResourceManagerId = properties == null ? "" : properties.getProperty("serverName") + "." + properties.getProperty("databaseName") + "." + properties.getProperty("portNumber");
    }

    private String xidDisplay(Xid xid) {
        if (null == xid) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("formatId=");
        stringBuffer.append(xid.getFormatId());
        stringBuffer.append(" gtrid=");
        stringBuffer.append(Util.byteToHexDisplayString(xid.getGlobalTransactionId()));
        stringBuffer.append(" bqual=");
        stringBuffer.append(Util.byteToHexDisplayString(xid.getBranchQualifier()));
        return stringBuffer.toString();
    }

    private String flagsDisplay(int n) {
        if (0 == n) {
            return "TMNOFLAGS";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (0 != (0x800000 & n)) {
            stringBuffer.append("TMENDRSCAN");
        }
        if (0 != (0x20000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMFAIL");
        }
        if (0 != (0x200000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMJOIN");
        }
        if (0 != (0x40000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMONEPHASE");
        }
        if (0 != (0x8000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMRESUME");
        }
        if (0 != (0x1000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSTARTRSCAN");
        }
        if (0 != (0x4000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUCCESS");
        }
        if (0 != (0x2000000 & n)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUSPEND");
        }
        return stringBuffer.toString();
    }

    private String cookieDisplay(byte[] byArray) {
        return Util.byteToHexDisplayString(byArray);
    }

    private String typeDisplay(int n) {
        switch (n) {
            case 0: {
                return "XA_START";
            }
            case 1: {
                return "XA_END";
            }
            case 2: {
                return "XA_PREPARE";
            }
            case 3: {
                return "XA_COMMIT";
            }
            case 4: {
                return "XA_ROLLBACK";
            }
            case 5: {
                return "XA_FORGET";
            }
            case 6: {
                return "XA_RECOVER";
            }
        }
        return "UNKNOWN" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XAReturnValue DTC_XA_Interface(int n, Xid xid, int n2) throws SQLException {
        XAReturnValue xAReturnValue;
        int n3;
        SQLException sQLException;
        block44: {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("Calling XA function for type:" + this.typeDisplay(n) + " flags:" + this.flagsDisplay(n2) + " xid:" + this.xidDisplay(xid));
            }
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (xid != null) {
                byArray = xid.getGlobalTransactionId();
                byArray2 = xid.getBranchQualifier();
            }
            sQLException = null;
            String string = "DTC_XA_";
            int n4 = 1;
            n3 = 0;
            xAReturnValue = new XAReturnValue();
            try {
                Object object;
                Object object2;
                SQLServerPreparedStatement sQLServerPreparedStatement = null;
                if (this.controlConnection == null) {
                    object2 = this;
                    synchronized (object2) {
                        if (this.controlConnection == null) {
                            try {
                                object = new SQLServerConnection();
                                ((SQLServerConnection)object).connect(this.con.activeConnectionProperties, null);
                                if (!xaInitDone) {
                                    Integer n5 = xaInitLock;
                                    synchronized (n5) {
                                        if (!xaInitDone) {
                                            SQLServerCallableStatement sQLServerCallableStatement = null;
                                            sQLServerCallableStatement = ((SQLServerConnection)object).createInternalCallableStatement("{call master..xp_sqljdbc_xa_init(?, ?)}");
                                            sQLServerCallableStatement.registerOutParameter(1, 4);
                                            sQLServerCallableStatement.registerOutParameter(2, 1);
                                            sQLServerCallableStatement.execute();
                                            int n6 = sQLServerCallableStatement.getInt(1);
                                            String string2 = sQLServerCallableStatement.getString(2);
                                            sQLServerCallableStatement.close();
                                            if (null != string2 && string2.length() > 1) {
                                                ((SQLServerConnection)object).close();
                                                throw new SQLException("xp_sqljdbc_xa_init failure, status:" + n6 + " msg:" + string2);
                                            }
                                            xaInitDone = true;
                                        }
                                    }
                                }
                                this.controlConnection = object;
                            }
                            catch (SQLException sQLException2) {
                                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_failedToCreateXAConnection"));
                                Object[] objectArray = new Object[]{new String(sQLException2.getMessage())};
                                throw new SQLException(messageFormat.format(objectArray));
                            }
                        }
                    }
                }
                switch (n) {
                    case 0: {
                        string = string + "START:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_start(?, ?, ?, ?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setBytes(n4++, byArray);
                        sQLServerPreparedStatement.setBytes(n4++, byArray2);
                        sQLServerPreparedStatement.setInt(n4++, n2);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, -2);
                        sQLServerPreparedStatement.setInt(n4++, this.timeoutSeconds);
                        break;
                    }
                    case 1: {
                        string = "END:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_end(?, ?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setBytes(n4++, byArray);
                        sQLServerPreparedStatement.setBytes(n4++, byArray2);
                        sQLServerPreparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 2: {
                        string = "PREPARE:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_prepare(?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setBytes(n4++, byArray);
                        sQLServerPreparedStatement.setBytes(n4++, byArray2);
                        break;
                    }
                    case 3: {
                        string = "COMMIT:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_commit(?, ?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setBytes(n4++, byArray);
                        sQLServerPreparedStatement.setBytes(n4++, byArray2);
                        sQLServerPreparedStatement.setInt(n4++, n2);
                        break;
                    }
                    case 4: {
                        string = "ROLLBACK:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_rollback(?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setBytes(n4++, byArray);
                        sQLServerPreparedStatement.setBytes(n4++, byArray2);
                        break;
                    }
                    case 5: {
                        string = "FORGET:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_forget(?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setBytes(n4++, byArray);
                        sQLServerPreparedStatement.setBytes(n4++, byArray2);
                        break;
                    }
                    case 6: {
                        string = "RECOVER:";
                        sQLServerPreparedStatement = this.controlConnection.createInternalCallableStatement("{call master..xp_sqljdbc_xa_recover(?, ?, ?, ?)}");
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 4);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, 1);
                        sQLServerPreparedStatement.setInt(n4++, n2);
                        ((SQLServerCallableStatement)sQLServerPreparedStatement).registerOutParameter(n4++, -2);
                    }
                }
                sQLServerPreparedStatement.execute();
                n3 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getInt(1);
                object2 = ((SQLServerCallableStatement)sQLServerPreparedStatement).getString(2);
                if (null != object2 && ((String)object2).length() > 1) {
                    sQLException = new SQLException(string + "Status:" + n3 + " msg:" + (String)object2);
                    break block44;
                }
                if (n == 0) {
                    object = ((SQLServerCallableStatement)sQLServerPreparedStatement).getBytes(6);
                    if (object == null) {
                        sQLException = new SQLException(string + "No transaction cookie returned");
                    } else {
                        try {
                            if (this.xaLogger.isLoggable(Level.FINE)) {
                                this.xaLogger.fine("Begin enlisting, cookie:" + this.cookieDisplay((byte[])object) + " enlisted count:" + this.enlistedTransactionCount);
                            }
                            this.con.JTAEnlistConnection((byte[])object);
                            ++this.enlistedTransactionCount;
                            if (this.xaLogger.isLoggable(Level.FINE)) {
                                this.xaLogger.fine("End enlisting, cookie:" + this.cookieDisplay((byte[])object) + " enlisted count:" + this.enlistedTransactionCount);
                            }
                        }
                        catch (SQLException sQLException3) {
                            sQLException = new SQLException("Failed to enlist:" + sQLException3.getMessage());
                        }
                    }
                }
                if (n == 1) {
                    try {
                        if (this.xaLogger.isLoggable(Level.FINE)) {
                            this.xaLogger.fine("Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                        }
                        this.con.JTAUnenlistConnection();
                        --this.enlistedTransactionCount;
                        if (this.xaLogger.isLoggable(Level.FINE)) {
                            this.xaLogger.fine("End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                        }
                    }
                    catch (SQLException sQLException4) {
                        sQLException = new SQLException("Failed to unenlist:" + sQLException4.getMessage());
                    }
                }
                if (n != 6) break block44;
                try {
                    xAReturnValue.bData = ((SQLServerCallableStatement)sQLServerPreparedStatement).getBytes(4);
                }
                catch (SQLException sQLException5) {
                    sQLException = new SQLException("Failed to read recovery XIDs:" + sQLException5.getMessage());
                }
            }
            catch (SQLException sQLException6) {
                sQLException = new SQLException(sQLException6.getMessage());
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        xAReturnValue.nStatus = n3;
        return xAReturnValue;
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("flags:" + this.flagsDisplay(n) + " xid:" + this.xidDisplay(xid));
            }
            this.DTC_XA_Interface(0, xid, n);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("flags:" + this.flagsDisplay(n) + " xid:" + this.xidDisplay(xid));
            }
            this.DTC_XA_Interface(1, xid, n);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        try {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("xid:" + this.xidDisplay(xid));
            }
            XAReturnValue xAReturnValue = this.DTC_XA_Interface(2, xid, 0);
            n = xAReturnValue.nStatus;
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
        return n;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("xid:" + this.xidDisplay(xid) + " onePhase:" + bl);
            }
            this.DTC_XA_Interface(3, xid, bl ? 0x40000000 : 0);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("xid:" + this.xidDisplay(xid));
            }
            this.DTC_XA_Interface(4, xid, 0);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("xid:" + this.xidDisplay(xid));
            }
            this.DTC_XA_Interface(5, xid, 0);
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public Xid[] recover(int n) throws XAException {
        try {
            int n2;
            int n3;
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("flags:" + this.flagsDisplay(n));
            }
            XAReturnValue xAReturnValue = this.DTC_XA_Interface(6, null, n);
            Vector<XidImpl> vector = new Vector<XidImpl>();
            if (null == xAReturnValue.bData) {
                return new XidImpl[0];
            }
            for (int i = 0; i < xAReturnValue.bData.length; i += n3) {
                int n4;
                int n5 = 1;
                n2 = 0;
                for (n4 = 0; n4 < 4; ++n4) {
                    n3 = xAReturnValue.bData[i + n4] & 0xFF;
                    n2 += (n3 *= n5);
                    n5 *= 256;
                }
                i += 4;
                n4 = xAReturnValue.bData[i++] & 0xFF;
                n3 = xAReturnValue.bData[i++] & 0xFF;
                byte[] byArray = new byte[n4];
                byte[] byArray2 = new byte[n3];
                System.arraycopy(xAReturnValue.bData, i, byArray, 0, n4);
                System.arraycopy(xAReturnValue.bData, i += n4, byArray2, 0, n3);
                XidImpl xidImpl = new XidImpl(n2, byArray, byArray2);
                vector.add(xidImpl);
            }
            Xid[] xidArray = new XidImpl[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                xidArray[n2] = (XidImpl)vector.elementAt(n2);
            }
            return xidArray;
        }
        catch (SQLException sQLException) {
            if (this.xaLogger.isLoggable(Level.FINE)) {
                this.xaLogger.fine("exception:" + sQLException);
            }
            throw new XAException(sQLException.toString());
        }
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine("xares:" + xAResource);
        }
        if (!(xAResource instanceof SQLServerXAResource)) {
            return false;
        }
        SQLServerXAResource sQLServerXAResource = (SQLServerXAResource)xAResource;
        return sQLServerXAResource.sResourceManagerId.equals(this.sResourceManagerId);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        this.timeoutSeconds = n;
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeoutSeconds;
    }

    static {
        xaInitLock = new Integer(0);
    }
}

