/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Calendar;

final class ServerDTVImpl
extends DTVImpl {
    private TypeInfo typeInfo;
    private int valueLength;
    private int valueOffset;
    private boolean isNull;
    byte[] binDataBuffer;
    int nIntValue;
    private char[] asciiConversionBuffer;
    static /* synthetic */ Class class$java$lang$Integer;

    ServerDTVImpl() {
    }

    final int setFromTDS(DTV dTV, TypeInfo typeInfo, int n, byte[] byArray, boolean bl) throws SQLServerException {
        int n2;
        this.typeInfo = typeInfo;
        this.binDataBuffer = byArray;
        if (35 == typeInfo.getTDSType() || 34 == typeInfo.getTDSType() || 99 == typeInfo.getTDSType()) {
            n2 = byArray[n];
            ++n;
            if (0 == n2) {
                this.valueLength = 0;
                this.isNull = true;
                this.valueOffset = n;
                return n;
            }
            if (bl) {
                n += 24;
            }
        }
        n2 = 0;
        boolean bl2 = true;
        int n3 = typeInfo.getValueLengthSize();
        if (typeInfo.isPLPType()) {
            try {
                PLPInputStream pLPInputStream = new PLPInputStream(byArray, n);
                n2 = pLPInputStream.getTDSBufferUsed();
                bl2 = pLPInputStream.isNull();
            }
            catch (Exception exception) {
                throw new SQLServerException(null, exception.getMessage(), null, 0, false);
            }
        } else if (0 == n3) {
            n2 = typeInfo.getMaxLength();
        } else if (1 == n3) {
            n2 = 0xFF & byArray[n++];
        } else {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                byte by;
                if ((by = byArray[n++]) != -1) {
                    bl2 = false;
                }
                n2 += (0 | 0xFF & by) << n4;
                n4 += 8;
            }
        }
        this.valueLength = n2;
        this.valueOffset = n;
        this.isNull = false;
        if (typeInfo.isPLPType()) {
            this.isNull = bl2;
        } else if (n3 == 2) {
            if (bl2) {
                this.isNull = true;
                n2 = 0;
            }
        } else if (n3 != 4) {
            this.isNull = n2 == 0;
        }
        return n += n2;
    }

    void setValue(DTV dTV, int n, Object object, Object object2) throws SQLServerException {
        dTV.setImpl(new AppDTVImpl());
        dTV.setValue(n, object, object2);
    }

    Object getSetterArgs() {
        return null;
    }

    boolean isNull() {
        return this.isNull;
    }

    int getJdbcType() throws SQLServerException {
        return DataTypes.nativeTypeToJdbcType(null, this.typeInfo.getNativeType(), this.typeInfo.getMaxLength());
    }

    private String getAsciiStringValueFast() {
        if (null == this.asciiConversionBuffer || this.valueLength > this.asciiConversionBuffer.length) {
            this.asciiConversionBuffer = new char[this.valueLength];
        }
        int n = this.valueOffset;
        for (int i = 0; i < this.valueLength; ++i) {
            char c;
            if ((c = (char)(this.binDataBuffer[n++] & 0xFF)) >= '\u0080') {
                return null;
            }
            this.asciiConversionBuffer[i] = c;
        }
        return new String(this.asciiConversionBuffer, 0, this.valueLength);
    }

    Object getValue(DTV dTV, int n, boolean bl, Object object) throws SQLServerException {
        Object object2;
        this.nIntValue = 0;
        if (!DataTypes.canConvertFromNativeTypeToJDBCType(this.typeInfo.getNativeType(), this.typeInfo.getMaxLength(), n)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{DataTypes.sqlNativeTypeToString(this.typeInfo.getNativeType()), Util.javaSqlTypeToString(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        if (this.isNull) {
            return null;
        }
        int n2 = 0;
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = ServerDTVImpl.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(object)) {
            object2 = (Integer)object;
            n2 = (Integer)object2;
        }
        if (this.typeInfo.isPLPType()) {
            try {
                switch (this.typeInfo.getNativeType()) {
                    case 165: 
                    case 240: {
                        object2 = new PLPInputStream(this.binDataBuffer, this.valueOffset);
                        return DDC.binaryPLPToObject((PLPInputStream)object2, this.typeInfo.getNativeType(), n, n2);
                    }
                    case 241: {
                        return DDC.xmlPLPToObject(this.binDataBuffer, this.valueOffset, this.typeInfo.getNativeType(), n, n2);
                    }
                    case 167: 
                    case 231: {
                        object2 = new PLPInputStream(this.binDataBuffer, this.valueOffset);
                        return DDC.characterPLPToObject((PLPInputStream)object2, this.typeInfo, n, n2);
                    }
                }
            }
            catch (Exception exception) {
                throw new SQLServerException(null, exception.getMessage(), null, 0, false);
            }
            throw new SQLServerException(null, SQLServerException.getErrString("R_invalidTDS"), null, 0, false);
        }
        if (n == -2) {
            return DDC.convertTDSBytesToRoundTrippableBytes(this.binDataBuffer, this.valueOffset, this.valueLength, this.typeInfo);
        }
        if (this.typeInfo.getNativeType() == 175 || this.typeInfo.getNativeType() == 167 || this.typeInfo.getNativeType() == 35 || this.typeInfo.getNativeType() == 239 || this.typeInfo.getNativeType() == 99 || this.typeInfo.getNativeType() == 231) {
            object2 = null;
            if (this.typeInfo.getNativeType() == 239 || this.typeInfo.getNativeType() == 231 || this.typeInfo.getNativeType() == 99) {
                try {
                    object2 = new String(this.binDataBuffer, this.valueOffset, this.valueLength, "UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
            }
            try {
                if (this.typeInfo.getSQLCollation().supportsAsciiConversion()) {
                    object2 = this.getAsciiStringValueFast();
                }
                if (null == object2) {
                    object2 = new String(this.binDataBuffer, this.valueOffset, this.valueLength, this.typeInfo.getCharset());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
            }
            return DDC.convertStringToObject((String)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 104) {
            int n3 = this.binDataBuffer[this.valueOffset] & 0xFF;
            object2 = new Integer(n3);
            return DDC.convertIntegerToObject((Integer)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 38) {
            int n4;
            int n5;
            int n6;
            int n7;
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            if (this.valueLength == 8) {
                l8 = (long)this.binDataBuffer[this.valueOffset] & 0xFFL;
                l7 = ((long)this.binDataBuffer[this.valueOffset + 1] & 0xFFL) << 8;
                l6 = ((long)this.binDataBuffer[this.valueOffset + 2] & 0xFFL) << 16;
                l5 = ((long)this.binDataBuffer[this.valueOffset + 3] & 0xFFL) << 24;
                l4 = ((long)this.binDataBuffer[this.valueOffset + 4] & 0xFFL) << 32;
                l3 = ((long)this.binDataBuffer[this.valueOffset + 5] & 0xFFL) << 40;
                l2 = ((long)this.binDataBuffer[this.valueOffset + 6] & 0xFFL) << 48;
                l = ((long)this.binDataBuffer[this.valueOffset + 7] & 0xFFL) << 56;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = 0;
            } else {
                n4 = this.binDataBuffer[this.valueOffset] & 0xFF;
                n5 = (this.binDataBuffer[this.valueOffset + 1] & 0xFF) << 8;
                n6 = (this.binDataBuffer[this.valueOffset + 2] & 0xFF) << 16;
                n7 = (this.binDataBuffer[this.valueOffset + 3] & 0xFF) << 24;
                l = 0L;
                l2 = 0L;
                l3 = 0L;
                l4 = 0L;
                l5 = 0L;
                l6 = 0L;
                l7 = 0L;
                l8 = 0L;
            }
            if (!bl) {
                if (n == 4 || n == 5 || n == -6) {
                    this.nIntValue = this.valueLength == 8 ? (int)(l5 | l6 | l7 | l8) : n7 | n6 | n5 | n4;
                    return null;
                }
                if (n == -5) {
                    long l9 = 0L;
                    l9 = this.valueLength == 8 ? l | l2 | l3 | l4 | l5 | l6 | l7 | l8 : (long)(n7 | n6 | n5 | n4);
                    return new Long(l9);
                }
            }
            if (this.valueLength == 4) {
                object2 = new Integer(n7 | n6 | n5 | n4);
                return DDC.convertIntegerToObject((Integer)object2, n, n2);
            }
            object2 = new Long(l | l2 | l3 | l4 | l5 | l6 | l7 | l8);
            return DDC.convertLongToObject((Long)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 11) {
            int n8 = this.binDataBuffer[this.valueOffset] & 0xFF;
            int n9 = (this.binDataBuffer[this.valueOffset + 1] & 0xFF) << 8;
            if (!(bl || n != 4 && n != 5 && n != -6)) {
                short s = (short)(n9 | n8);
                this.nIntValue = s;
                return null;
            }
            object2 = new Short((short)(n8 | n9));
            Integer n10 = new Integer(((Short)object2).intValue());
            return DDC.convertIntegerToObject(n10, n, n2);
        }
        if (this.typeInfo.getNativeType() == 10) {
            int n11 = this.binDataBuffer[this.valueOffset] & 0xFF;
            if (!(bl || n != 4 && n != 5 && n != -6)) {
                this.nIntValue = n11;
                return null;
            }
            object2 = new Integer(n11);
            return DDC.convertIntegerToObject((Integer)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 106 || this.typeInfo.getNativeType() == 108 || Util.isBigInt(this.typeInfo.getNativeType(), this.valueLength) || this.typeInfo.getNativeType() == 110 || this.typeInfo.getNativeType() == 14) {
            object2 = null;
            object2 = this.typeInfo.getNativeType() == 106 || this.typeInfo.getNativeType() == 108 || Util.isBigInt(this.typeInfo.getNativeType(), this.valueLength) ? Util.bytesToBigDecimal(this.binDataBuffer, this.valueOffset, this.valueLength, this.typeInfo.getScale()) : Util.moneyBytesToBigDecimal(null, this.binDataBuffer, this.valueOffset, this.valueLength);
            return DDC.convertBigDecimalToObject((BigDecimal)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 109) {
            object2 = Util.bytesToDouble(null, this.binDataBuffer, this.valueOffset, this.valueLength);
            return DDC.convertDoubleToObject((Double)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 16) {
            object2 = Util.bytesToFloat(null, this.binDataBuffer, this.valueOffset, this.valueLength);
            return DDC.convertFloatToObject((Float)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 111 || this.typeInfo.getNativeType() == 12) {
            object2 = Util.bytesToTimestamp(null, this.binDataBuffer, this.valueOffset, this.valueLength, (Calendar)object);
            return DDC.convertTimestampToObject((Timestamp)object2, n, n2);
        }
        if (this.typeInfo.getNativeType() == 34 || this.typeInfo.getNativeType() == 173 || this.typeInfo.getNativeType() == 36 || this.typeInfo.getNativeType() == 165) {
            object2 = new byte[this.valueLength];
            System.arraycopy(this.binDataBuffer, this.valueOffset, object2, 0, this.valueLength);
            if (1 == n2 || 3 == n2) {
                return new ByteArrayInputStream((byte[])object2);
            }
            switch (n) {
                case 2004: {
                    return new SQLServerBlob(null, (byte[])object2);
                }
                case -1: 
                case 1: 
                case 12: {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this.typeInfo.getNativeType() == 36) {
                        int n12;
                        for (n12 = 0; n12 < 4; ++n12) {
                            stringBuffer.append(ParameterUtils.hex[(object2[3 - n12] & 0xF0) >> 4]);
                            stringBuffer.append(ParameterUtils.hex[object2[3 - n12] & 0xF]);
                        }
                        stringBuffer.append("-");
                        for (n12 = 0; n12 < 2; ++n12) {
                            stringBuffer.append(ParameterUtils.hex[(object2[5 - n12] & 0xF0) >> 4]);
                            stringBuffer.append(ParameterUtils.hex[object2[5 - n12] & 0xF]);
                        }
                        stringBuffer.append("-");
                        for (n12 = 0; n12 < 2; ++n12) {
                            stringBuffer.append(ParameterUtils.hex[(object2[7 - n12] & 0xF0) >> 4]);
                            stringBuffer.append(ParameterUtils.hex[object2[7 - n12] & 0xF]);
                        }
                        stringBuffer.append("-");
                        for (n12 = 0; n12 < 2; ++n12) {
                            stringBuffer.append(ParameterUtils.hex[(object2[8 + n12] & 0xF0) >> 4]);
                            stringBuffer.append(ParameterUtils.hex[object2[8 + n12] & 0xF]);
                        }
                        stringBuffer.append("-");
                        for (n12 = 0; n12 < 6; ++n12) {
                            stringBuffer.append(ParameterUtils.hex[(object2[10 + n12] & 0xF0) >> 4]);
                            stringBuffer.append(ParameterUtils.hex[object2[10 + n12] & 0xF]);
                        }
                    } else {
                        for (int i = 0; i < this.valueLength; ++i) {
                            stringBuffer.append(ParameterUtils.hex[(object2[i] & 0xF0) >> 4]);
                            stringBuffer.append(ParameterUtils.hex[object2[i] & 0xF]);
                        }
                    }
                    return DDC.convertStringToObject(stringBuffer.toString(), n, n2);
                }
            }
            return object2;
        }
        object2 = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
        Object[] objectArray = new Object[]{DataTypes.sqlNativeTypeToString(this.typeInfo.getNativeType()), DataTypes.classNameFromJDBCType(n)};
        String string = ((Format)object2).format(objectArray);
        SQLServerException.makeFromDriverError(null, null, string, null, true);
        return null;
    }

    int getInt() {
        return this.nIntValue;
    }

    short getShort() {
        return (short)this.nIntValue;
    }

    byte getByte(DTV dTV) throws SQLServerException {
        return (byte)dTV.getInt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

