/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.Node;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.ParserTreeConstants;
import org.apache.commons.jexl2.parser.ParserVisitor;

public class SimpleNode
implements Node {
    protected JexlNode parent;
    protected JexlNode[] children;
    protected final int id;
    protected volatile Object value;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(Parser p, int i) {
        this(i);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = (JexlNode)n;
    }

    public JexlNode jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new JexlNode[i + 1];
        } else if (i >= this.children.length) {
            JexlNode[] c = new JexlNode[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = (JexlNode)n;
    }

    public JexlNode jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(ParserVisitor visitor, Object data) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                JexlNode n = this.children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }
}

