/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.scripting;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.scripting.JexlScriptEngineFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JexlScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private static final Log LOG = LogFactory.getLog(JexlScriptEngine.class);
    private static final int CACHE_SIZE = 512;
    public static final String CONTEXT_KEY = "context";
    public static final String JEXL_OBJECT_KEY = "JEXL";
    private final JexlScriptObject jexlObject;
    private final ScriptEngineFactory parentFactory;
    private final JexlEngine jexlEngine;

    public JexlScriptEngine() {
        this(FactorySingletonHolder.DEFAULT_FACTORY);
    }

    public JexlScriptEngine(ScriptEngineFactory factory) {
        if (factory == null) {
            throw new NullPointerException("ScriptEngineFactory must not be null");
        }
        this.parentFactory = factory;
        this.jexlEngine = EngineSingletonHolder.DEFAULT_ENGINE;
        this.jexlObject = new JexlScriptObject();
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        if (reader == null || context == null) {
            throw new NullPointerException("script and context must be non-null");
        }
        return this.eval(this.readerToString(reader), context);
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null || context == null) {
            throw new NullPointerException("script and context must be non-null");
        }
        context.setAttribute(CONTEXT_KEY, context, 100);
        try {
            Script jexlScript = this.jexlEngine.createScript(script);
            JexlContextWrapper ctxt = new JexlContextWrapper(context);
            return jexlScript.execute(ctxt);
        }
        catch (Exception e) {
            throw new ScriptException(e.toString());
        }
    }

    public ScriptEngineFactory getFactory() {
        return this.parentFactory;
    }

    public CompiledScript compile(String script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script must be non-null");
        }
        try {
            Script jexlScript = this.jexlEngine.createScript(script);
            return new JexlCompiledScript(jexlScript);
        }
        catch (Exception e) {
            throw new ScriptException(e.toString());
        }
    }

    public CompiledScript compile(Reader script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script must be non-null");
        }
        return this.compile(this.readerToString(script));
    }

    private String readerToString(Reader script) throws ScriptException {
        try {
            return JexlEngine.readerToString(script);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private static class EngineSingletonHolder {
        private static final JexlEngine DEFAULT_ENGINE = new JexlEngine(null, null, null, JexlScriptEngine.access$2()){
            {
                this.setCache(512);
            }
        };

        private EngineSingletonHolder() {
        }
    }

    private static class FactorySingletonHolder {
        private static final JexlScriptEngineFactory DEFAULT_FACTORY = new JexlScriptEngineFactory();

        private FactorySingletonHolder() {
        }
    }

    private final class JexlCompiledScript
    extends CompiledScript {
        private final Script script;

        private JexlCompiledScript(Script theScript) {
            this.script = theScript;
        }

        public String toString() {
            return this.script.getText();
        }

        public Object eval(ScriptContext context) throws ScriptException {
            context.setAttribute(JexlScriptEngine.CONTEXT_KEY, context, 100);
            try {
                JexlContextWrapper ctxt = new JexlContextWrapper(context);
                return this.script.execute(ctxt);
            }
            catch (Exception e) {
                throw new ScriptException(e.toString());
            }
        }

        public ScriptEngine getEngine() {
            return JexlScriptEngine.this;
        }
    }

    private final class JexlContextWrapper
    implements JexlContext {
        private final ScriptContext scriptContext;

        private JexlContextWrapper(ScriptContext theContext) {
            this.scriptContext = theContext;
        }

        public Object get(String name) {
            Object o = this.scriptContext.getAttribute(name);
            if (JexlScriptEngine.JEXL_OBJECT_KEY.equals(name)) {
                if (o != null) {
                    LOG.warn((Object)"JEXL is a reserved variable name, user defined value is ignored");
                }
                return JexlScriptEngine.this.jexlObject;
            }
            return o;
        }

        public void set(String name, Object value) {
            int scope = this.scriptContext.getAttributesScope(name);
            if (scope == -1) {
                scope = 100;
            }
            this.scriptContext.getBindings(scope).put(name, value);
        }

        public boolean has(String name) {
            Bindings bnd = this.scriptContext.getBindings(100);
            return bnd.containsKey(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JexlScriptObject {
        public JexlEngine getEngine() {
            return JexlScriptEngine.this.jexlEngine;
        }

        public PrintWriter getOut() {
            Writer out = JexlScriptEngine.this.context.getWriter();
            if (out instanceof PrintWriter) {
                return (PrintWriter)out;
            }
            if (out != null) {
                return new PrintWriter(out, true);
            }
            return null;
        }

        public PrintWriter getErr() {
            Writer error = JexlScriptEngine.this.context.getErrorWriter();
            if (error instanceof PrintWriter) {
                return (PrintWriter)error;
            }
            if (error != null) {
                return new PrintWriter(error, true);
            }
            return null;
        }

        public Reader getIn() {
            return JexlScriptEngine.this.context.getReader();
        }

        public Class<System> getSystem() {
            return System.class;
        }

        public Log getLogger() {
            return LOG;
        }
    }
}

