/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.scripting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.parser.StringParser;
import org.apache.commons.jexl2.scripting.JexlScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlScriptEngineFactory
implements ScriptEngineFactory {
    @Override
    public String getEngineName() {
        return "JEXL Engine";
    }

    @Override
    public String getEngineVersion() {
        return "2.0";
    }

    @Override
    public String getLanguageName() {
        return "JEXL";
    }

    @Override
    public String getLanguageVersion() {
        return "2.0";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj);
        sb.append('.');
        sb.append(m);
        sb.append('(');
        boolean needComma = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (needComma) {
                sb.append(',');
            }
            sb.append(arg);
            needComma = true;
            ++n2;
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public List<String> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList("jexl", "jexl2"));
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.unmodifiableList(Arrays.asList("application/x-jexl", "application/x-jexl2"));
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(Arrays.asList("JEXL", "Jexl", "jexl", "JEXL2", "Jexl2", "jexl2"));
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        if (toDisplay == null) {
            return "JEXL.out.print(null)";
        }
        return "JEXL.out.print(" + StringParser.escapeString(toDisplay, '\'') + ")";
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getNames();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return null;
        }
        return null;
    }

    @Override
    public String getProgram(String[] statements) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            String statement = stringArray[n2];
            sb.append(JexlEngine.cleanExpression(statement));
            if (!statement.endsWith(";")) {
                sb.append(';');
            }
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        JexlScriptEngine engine = new JexlScriptEngine(this);
        return engine;
    }
}

