/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;

public class WithDefaultsRulesWrapper
implements Rules {
    private Rules wrappedRules;
    private List defaultRules = new ArrayList();
    private List allRules = new ArrayList();

    public WithDefaultsRulesWrapper(Rules rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Wrapped rules must not be null");
        }
        this.wrappedRules = rules;
    }

    public Digester getDigester() {
        return this.wrappedRules.getDigester();
    }

    public void setDigester(Digester digester) {
        this.wrappedRules.setDigester(digester);
        Iterator iterator = this.defaultRules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            rule.setDigester(digester);
        }
    }

    public String getNamespaceURI() {
        return this.wrappedRules.getNamespaceURI();
    }

    public void setNamespaceURI(String string) {
        this.wrappedRules.setNamespaceURI(string);
    }

    public List getDefaults() {
        return this.defaultRules;
    }

    public List match(String string) {
        return this.match("", string);
    }

    public List match(String string, String string2) {
        List list = this.wrappedRules.match(string, string2);
        if (list == null || list.isEmpty()) {
            return new ArrayList(this.defaultRules);
        }
        return list;
    }

    public void addDefault(Rule rule) {
        if (this.wrappedRules.getDigester() != null) {
            rule.setDigester(this.wrappedRules.getDigester());
        }
        if (this.wrappedRules.getNamespaceURI() != null) {
            rule.setNamespaceURI(this.wrappedRules.getNamespaceURI());
        }
        this.defaultRules.add(rule);
        this.allRules.add(rule);
    }

    public List rules() {
        return this.allRules;
    }

    public void clear() {
        this.wrappedRules.clear();
        this.allRules.clear();
        this.defaultRules.clear();
    }

    public void add(String string, Rule rule) {
        this.wrappedRules.add(string, rule);
        this.allRules.add(rule);
    }
}

