/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.plugins.Declaration;
import org.apache.commons.digester.plugins.LogUtils;
import org.apache.commons.digester.plugins.PluginContext;
import org.apache.commons.digester.plugins.PluginException;
import org.apache.commons.digester.plugins.RuleFinder;
import org.apache.commons.digester.plugins.RuleLoader;
import org.apache.commons.logging.Log;

public class PluginManager {
    private HashMap declarationsByClass = new HashMap();
    private HashMap declarationsById = new HashMap();
    private PluginManager parent;
    private PluginContext pluginContext;

    public PluginManager(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public PluginManager(PluginManager pluginManager) {
        this.parent = pluginManager;
        this.pluginContext = pluginManager.pluginContext;
    }

    public void addDeclaration(Declaration declaration) {
        Log log = LogUtils.getLogger(null);
        boolean bl = log.isDebugEnabled();
        Class clazz = declaration.getPluginClass();
        String string = declaration.getId();
        this.declarationsByClass.put(clazz.getName(), declaration);
        if (string != null) {
            this.declarationsById.put(string, declaration);
            if (bl) {
                log.debug((Object)("Indexing plugin-id [" + string + "]" + " -> class [" + clazz.getName() + "]"));
            }
        }
    }

    public Declaration getDeclarationByClass(String string) {
        Declaration declaration = (Declaration)this.declarationsByClass.get(string);
        if (declaration == null && this.parent != null) {
            declaration = this.parent.getDeclarationByClass(string);
        }
        return declaration;
    }

    public Declaration getDeclarationById(String string) {
        Declaration declaration = (Declaration)this.declarationsById.get(string);
        if (declaration == null && this.parent != null) {
            declaration = this.parent.getDeclarationById(string);
        }
        return declaration;
    }

    public RuleLoader findLoader(Digester digester, String string, Class clazz, Properties properties) throws PluginException {
        Log log = LogUtils.getLogger(digester);
        boolean bl = log.isDebugEnabled();
        log.debug((Object)"scanning ruleFinders to locate loader..");
        List list = this.pluginContext.getRuleFinders();
        RuleLoader ruleLoader = null;
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ruleLoader == null) {
                RuleFinder ruleFinder = (RuleFinder)iterator.next();
                if (bl) {
                    log.debug((Object)("checking finder of type " + ruleFinder.getClass().getName()));
                }
                ruleLoader = ruleFinder.findLoader(digester, clazz, properties);
            }
        }
        catch (PluginException pluginException) {
            throw new PluginException("Unable to locate plugin rules for plugin with id [" + string + "]" + ", and class [" + clazz.getName() + "]" + ":" + pluginException.getMessage(), pluginException.getCause());
        }
        log.debug((Object)"scanned ruleFinders.");
        return ruleLoader;
    }
}

