/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;
import org.xml.sax.SAXException;

public class DigestingPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$struts$plugins$DigestingPlugIn == null ? (class$org$apache$struts$plugins$DigestingPlugIn = DigestingPlugIn.class$("org.apache.struts.plugins.DigestingPlugIn")) : class$org$apache$struts$plugins$DigestingPlugIn));
    protected static final String SOURCE_CLASSPATH = "classpath";
    protected static final String SOURCE_FILE = "file";
    protected static final String SOURCE_SERVLET = "servlet";
    protected String configPath = null;
    protected String configSource = "servlet";
    protected String digesterPath = null;
    protected String digesterSource = "servlet";
    protected String key = null;
    protected ModuleConfig moduleConfig = null;
    protected String rulesets = null;
    protected ActionServlet servlet = null;
    protected boolean push = false;
    static /* synthetic */ Class class$org$apache$struts$plugins$DigestingPlugIn;

    public void destroy() {
        this.servlet = null;
        this.moduleConfig = null;
    }

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        this.servlet = actionServlet;
        this.moduleConfig = moduleConfig;
        Object object = null;
        Digester digester = this.initializeDigester();
        if (this.push) {
            log.debug((Object)"push == true; pushing plugin onto digester stack");
            digester.push((Object)this);
        }
        try {
            log.debug((Object)("XML data file: [path: " + this.configPath + ", source: " + this.configSource + "]"));
            URL uRL = this.getConfigURL(this.configPath, this.configSource);
            if (uRL == null) {
                throw new ServletException("Unable to locate XML data file at [path: " + this.configPath + ", source: " + this.configSource + "]");
            }
            object = digester.parse(uRL.openStream());
        }
        catch (IOException iOException) {
            log.error((Object)"Exception processing config", (Throwable)iOException);
            throw new ServletException((Throwable)iOException);
        }
        catch (SAXException sAXException) {
            log.error((Object)"Exception processing config", (Throwable)sAXException);
            throw new ServletException((Throwable)sAXException);
        }
        this.storeGeneratedObject(object);
    }

    protected Digester initializeDigester() throws ServletException {
        Digester digester = null;
        if (this.digesterPath != null && this.digesterSource != null) {
            try {
                log.debug((Object)("Initialize digester from XML [path: " + this.digesterPath + "; source: " + this.digesterSource + "]"));
                digester = this.digesterFromXml(this.digesterPath, this.digesterSource);
            }
            catch (IOException iOException) {
                log.error((Object)"Exception instantiating digester from XML ", (Throwable)iOException);
                throw new ServletException((Throwable)iOException);
            }
        } else {
            log.debug((Object)"No XML rules for digester; call newDigesterInstance()");
            digester = this.newDigesterInstance();
        }
        this.applyRuleSets(digester);
        return digester;
    }

    protected Digester newDigesterInstance() {
        return new Digester();
    }

    protected Digester digesterFromXml(String string, String string2) throws IOException {
        URL uRL = this.getConfigURL(string, string2);
        if (uRL == null) {
            throw new NullPointerException("No resource '" + string + "' found in '" + string2 + "'");
        }
        return DigesterLoader.createDigester((URL)uRL);
    }

    protected void applyRuleSets(Digester digester) throws ServletException {
        if (this.rulesets == null || this.rulesets.trim().length() == 0) {
            return;
        }
        this.rulesets = this.rulesets.trim();
        String string = null;
        while (this.rulesets.length() > 0) {
            int n = this.rulesets.indexOf(",");
            if (n < 0) {
                string = this.rulesets.trim();
                this.rulesets = "";
            } else {
                string = this.rulesets.substring(0, n).trim();
                this.rulesets = this.rulesets.substring(n + 1).trim();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuring custom Digester Ruleset of type " + string));
            }
            try {
                RuleSet ruleSet = (RuleSet)RequestUtils.applicationInstance(string);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception exception) {
                log.error((Object)"Exception configuring custom Digester RuleSet", (Throwable)exception);
                throw new ServletException((Throwable)exception);
            }
        }
    }

    protected URL getConfigURL(String string, String string2) throws IOException {
        if (SOURCE_CLASSPATH.equals(string2)) {
            return this.getClassPathURL(string);
        }
        if (SOURCE_FILE.equals(string2)) {
            return this.getFileURL(string);
        }
        if (SOURCE_SERVLET.equals(string2)) {
            return this.getServletContextURL(string);
        }
        throw new IllegalArgumentException("ConfigSource " + string2 + " is not recognized");
    }

    protected URL getClassPathURL(String string) {
        return this.getClass().getClassLoader().getResource(string);
    }

    protected URL getServletContextURL(String string) throws IOException {
        return this.servlet.getServletContext().getResource(string);
    }

    protected URL getFileURL(String string) throws IOException {
        File file = new File(string);
        return file.toURL();
    }

    public void setConfigPath(String string) {
        this.configPath = string;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigSource(String string) {
        this.configSource = string;
    }

    public String getConfigSource() {
        return this.configSource;
    }

    protected void storeGeneratedObject(Object object) {
        log.debug((Object)("Put [" + object + "] into application context [key:" + this.key + "]"));
        this.servlet.getServletContext().setAttribute(this.getKey(), object);
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setRulesets(String string) {
        this.rulesets = string;
    }

    public String getRulesets() {
        return this.rulesets;
    }

    public void setDigesterPath(String string) {
        this.digesterPath = string;
    }

    public String getDigesterPath() {
        return this.digesterPath;
    }

    public void setDigesterSource(String string) {
        this.digesterSource = string;
    }

    public String getDigesterSource() {
        return this.digesterSource;
    }

    public void setPush(boolean bl) {
        this.push = bl;
    }

    public boolean getPush() {
        return this.push;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

