/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import java.security.Principal;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.logic.ConditionalTagBase;

public class PresentTag
extends ConditionalTagBase {
    public static final String ROLE_DELIMITER = ",";

    protected boolean condition() throws JspException {
        return this.condition(true);
    }

    protected boolean condition(boolean bl) throws JspException {
        boolean bl2 = false;
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        if (this.cookie != null) {
            bl2 = this.isCookiePresent(httpServletRequest);
        } else if (this.header != null) {
            String string = httpServletRequest.getHeader(this.header);
            bl2 = string != null;
        } else if (this.name != null) {
            bl2 = this.isBeanPresent();
        } else if (this.parameter != null) {
            String string = httpServletRequest.getParameter(this.parameter);
            bl2 = string != null;
        } else if (this.role != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.role, ROLE_DELIMITER, false);
            while (!bl2 && stringTokenizer.hasMoreTokens()) {
                bl2 = httpServletRequest.isUserInRole(stringTokenizer.nextToken());
            }
        } else if (this.user != null) {
            Principal principal = httpServletRequest.getUserPrincipal();
            bl2 = principal != null && this.user.equals(principal.getName());
        } else {
            JspException jspException = new JspException(ConditionalTagBase.messages.getMessage("logic.selector"));
            TagUtils.getInstance().saveException(this.pageContext, jspException);
            throw jspException;
        }
        return bl2 == bl;
    }

    protected boolean isBeanPresent() {
        Object object = null;
        try {
            object = this.property != null ? TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope) : TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope);
        }
        catch (JspException jspException) {
            object = null;
        }
        return object != null;
    }

    protected boolean isCookiePresent(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return false;
        }
        int n = 0;
        while (n < cookieArray.length) {
            if (this.cookie.equals(cookieArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

