/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class RedirectTag
extends TagSupport {
    protected String anchor = null;
    protected String forward = null;
    protected String href = null;
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.logic.LocalStrings");
    protected String name = null;
    protected String page = null;
    protected String action = null;
    protected String module = null;
    protected String paramId = null;
    protected String paramName = null;
    protected String paramProperty = null;
    protected String paramScope = null;
    protected String property = null;
    protected String scope = null;
    protected boolean transaction = false;
    protected boolean useLocalEncoding = false;

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String string) {
        this.anchor = string;
    }

    public String getForward() {
        return this.forward;
    }

    public void setForward(String string) {
        this.forward = string;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String string) {
        this.page = string;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getParamId() {
        return this.paramId;
    }

    public void setParamId(String string) {
        this.paramId = string;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String string) {
        this.paramName = string;
    }

    public String getParamProperty() {
        return this.paramProperty;
    }

    public void setParamProperty(String string) {
        this.paramProperty = string;
    }

    public String getParamScope() {
        return this.paramScope;
    }

    public void setParamScope(String string) {
        this.paramScope = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public boolean getTransaction() {
        return this.transaction;
    }

    public void setTransaction(boolean bl) {
        this.transaction = bl;
    }

    public boolean isUseLocalEncoding() {
        return this.useLocalEncoding;
    }

    public void setUseLocalEncoding(boolean bl) {
        this.useLocalEncoding = bl;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        this.doRedirect(this.generateRedirectURL());
        return 5;
    }

    protected String generateRedirectURL() throws JspException {
        Map map = TagUtils.getInstance().computeParameters(this.pageContext, this.paramId, this.paramName, this.paramProperty, this.paramScope, this.name, this.property, this.scope, this.transaction);
        String string = null;
        try {
            string = TagUtils.getInstance().computeURLWithCharEncoding(this.pageContext, this.forward, this.href, this.page, this.action, this.module, map, this.anchor, true, this.useLocalEncoding);
        }
        catch (MalformedURLException malformedURLException) {
            TagUtils.getInstance().saveException(this.pageContext, malformedURLException);
            throw new JspException(messages.getMessage("redirect.url", (Object)malformedURLException.toString()));
        }
        return string;
    }

    protected void doRedirect(String string) throws JspException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        try {
            httpServletResponse.sendRedirect(string);
        }
        catch (IOException iOException) {
            TagUtils.getInstance().saveException(this.pageContext, iOException);
            throw new JspException(iOException.getMessage());
        }
    }

    public void release() {
        super.release();
        this.anchor = null;
        this.forward = null;
        this.href = null;
        this.name = null;
        this.page = null;
        this.action = null;
        this.paramId = null;
        this.paramName = null;
        this.paramProperty = null;
        this.paramScope = null;
        this.property = null;
        this.scope = null;
    }
}

