/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.AttributeDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionNameAttribute;
import org.apache.struts.tiles.DirectStringAttribute;
import org.apache.struts.tiles.PathAttribute;
import org.apache.struts.tiles.UntypedAttribute;
import org.apache.struts.tiles.UrlController;
import org.apache.struts.tiles.xmlDefinition.XmlDefinition;
import org.apache.struts.util.RequestUtils;

public class ComponentDefinition
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$tiles$ComponentDefinition == null ? (class$org$apache$struts$tiles$ComponentDefinition = ComponentDefinition.class$("org.apache.struts.tiles.ComponentDefinition")) : class$org$apache$struts$tiles$ComponentDefinition));
    protected String name = null;
    protected String path = null;
    protected Map attributes = null;
    protected String role = null;
    protected String controller = null;
    protected String controllerType = null;
    public static final String URL = "url";
    public static final String CONTROLLER = "controller";
    public static final String ACTION = "action";
    private Controller controllerInstance = null;
    static /* synthetic */ Class class$org$apache$struts$tiles$ComponentDefinition;

    public ComponentDefinition() {
        this.attributes = new HashMap();
    }

    public ComponentDefinition(ComponentDefinition componentDefinition) {
        this.attributes = new HashMap(componentDefinition.getAttributes());
        this.name = componentDefinition.getName();
        this.path = componentDefinition.getPath();
        this.role = componentDefinition.getRole();
        this.controllerInstance = componentDefinition.getControllerInstance();
        this.controller = componentDefinition.getController();
        this.controllerType = componentDefinition.getControllerType();
    }

    public ComponentDefinition(XmlDefinition xmlDefinition) {
        this((ComponentDefinition)xmlDefinition);
    }

    public ComponentDefinition(String string, String string2, Map map) {
        this.name = string;
        this.path = string2;
        this.attributes = map;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPage() {
        return this.path;
    }

    public void setPage(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getTemplate() {
        return this.path;
    }

    public void setTemplate(String string) {
        this.path = string;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void putAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void put(String string, Object object) {
        this.put(string, object, false, null);
    }

    public void put(String string, Object object, boolean bl) {
        this.put(string, object, bl, null);
    }

    public void put(String string, Object object, boolean bl, String string2) {
        if (bl) {
            this.put(string, object, "string", string2);
        } else {
            this.put(string, object, "template", string2);
        }
    }

    public void put(String string, Object object, String string2, String string3) {
        UntypedAttribute untypedAttribute = null;
        if (object != null && string2 != null && !(object instanceof AttributeDefinition)) {
            String string4 = object.toString();
            if (string2.equalsIgnoreCase("string")) {
                untypedAttribute = new DirectStringAttribute(string4);
            } else if (string2.equalsIgnoreCase("page")) {
                untypedAttribute = new PathAttribute(string4);
            } else if (string2.equalsIgnoreCase("template")) {
                untypedAttribute = new PathAttribute(string4);
            } else if (string2.equalsIgnoreCase("instance")) {
                untypedAttribute = new DefinitionNameAttribute(string4);
            } else if (string2.equalsIgnoreCase("definition")) {
                untypedAttribute = new DefinitionNameAttribute(string4);
            }
        }
        this.putAttribute(string, untypedAttribute);
    }

    public String toString() {
        return "{name=" + this.name + ", path=" + this.path + ", role=" + this.role + ", controller=" + this.controller + ", controllerType=" + this.controllerType + ", controllerInstance=" + this.controllerInstance + ", attributes=" + this.attributes + "}\n";
    }

    public String getControllerType() {
        return this.controllerType;
    }

    public void setControllerType(String string) {
        this.controllerType = string;
    }

    public void setControllerUrl(String string) {
        this.setController(string);
        this.setControllerType(URL);
    }

    public void setControllerClass(String string) {
        this.setController(string);
        this.setControllerType("classname");
    }

    public String getController() {
        return this.controller;
    }

    public void setController(String string) {
        this.controller = string;
    }

    public Controller getControllerInstance() {
        return this.controllerInstance;
    }

    public Controller getOrCreateController() throws InstantiationException {
        if (this.controllerInstance != null) {
            return this.controllerInstance;
        }
        if (this.controller == null && this.controllerType == null) {
            return null;
        }
        if (this.controllerType != null && this.controller == null) {
            throw new InstantiationException("Controller name should be defined if controllerType is set");
        }
        this.controllerInstance = ComponentDefinition.createController(this.controller, this.controllerType);
        return this.controllerInstance;
    }

    public void setControllerInstance(Controller controller) {
        this.controllerInstance = controller;
    }

    public static Controller createController(String string, String string2) throws InstantiationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create controller name=" + string + ", type=" + string2));
        }
        Controller controller = null;
        if (string2 == null) {
            try {
                return ComponentDefinition.createControllerFromClassname(string);
            }
            catch (InstantiationException instantiationException) {
                controller = new UrlController(string);
            }
        } else if (URL.equalsIgnoreCase(string2)) {
            controller = new UrlController(string);
        } else if ("classname".equalsIgnoreCase(string2)) {
            controller = ComponentDefinition.createControllerFromClassname(string);
        }
        return controller;
    }

    public static Controller createControllerFromClassname(String string) throws InstantiationException {
        try {
            Class clazz = RequestUtils.applicationClass(string);
            Object t = clazz.newInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Controller created : " + t));
            }
            return (Controller)t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InstantiationException("Error - Class not found :" + classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InstantiationException("Error - Illegal class access :" + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw instantiationException;
        }
        catch (ClassCastException classCastException) {
            throw new InstantiationException("Controller of class '" + string + "' should implements 'Controller' or extends 'Action'");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

