/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.definition;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.xmlDefinition.I18nFactorySet;
import org.apache.struts.util.RequestUtils;

public class ReloadableDefinitionsFactory
implements ComponentDefinitionsFactory {
    protected ComponentDefinitionsFactory factory = null;
    protected Map properties = null;
    public static final String DEFINITIONS_FACTORY_CLASSNAME = "definitions-factory-class";

    public ReloadableDefinitionsFactory(ServletContext servletContext, ServletConfig servletConfig) throws DefinitionsFactoryException {
        this.properties = new ServletPropertiesMap(servletConfig);
        this.factory = this.createFactory(servletContext, this.properties);
    }

    public ReloadableDefinitionsFactory(ServletContext servletContext, Map map) throws DefinitionsFactoryException {
        this.properties = map;
        this.factory = this.createFactory(servletContext, map);
    }

    public ComponentDefinitionsFactory createFactoryFromClassname(ServletContext servletContext, Map map, String string) throws DefinitionsFactoryException {
        if (string == null) {
            return this.createFactory(servletContext, map);
        }
        try {
            Class clazz = RequestUtils.applicationClass(string);
            ComponentDefinitionsFactory componentDefinitionsFactory = (ComponentDefinitionsFactory)clazz.newInstance();
            componentDefinitionsFactory.initFactory(servletContext, map);
            return componentDefinitionsFactory;
        }
        catch (ClassCastException classCastException) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + string + " must implements 'ComponentDefinitionsFactory'.", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + string + "'.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new DefinitionsFactoryException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DefinitionsFactoryException(illegalAccessException);
        }
    }

    public ComponentDefinitionsFactory createDefaultFactory(ServletContext servletContext, Map map) throws DefinitionsFactoryException {
        I18nFactorySet i18nFactorySet = new I18nFactorySet(servletContext, map);
        return i18nFactorySet;
    }

    public ComponentDefinitionsFactory createFactory(ServletContext servletContext, Map map) throws DefinitionsFactoryException {
        String string = (String)map.get(DEFINITIONS_FACTORY_CLASSNAME);
        if (string != null) {
            return this.createFactoryFromClassname(servletContext, map, string);
        }
        return new I18nFactorySet(servletContext, map);
    }

    public ComponentDefinition getDefinition(String string, ServletRequest servletRequest, ServletContext servletContext) throws FactoryNotFoundException, DefinitionsFactoryException {
        return this.factory.getDefinition(string, (ServletRequest)((HttpServletRequest)servletRequest), servletContext);
    }

    public void reload(ServletContext servletContext) throws DefinitionsFactoryException {
        ComponentDefinitionsFactory componentDefinitionsFactory;
        this.factory = componentDefinitionsFactory = this.createFactory(servletContext, this.properties);
    }

    public ComponentDefinitionsFactory getFactory() {
        return this.factory;
    }

    public void initFactory(ServletContext servletContext, Map map) throws DefinitionsFactoryException {
    }

    public String toString() {
        return this.factory.toString();
    }

    class ServletPropertiesMap
    extends HashMap {
        ServletPropertiesMap(ServletConfig servletConfig) {
            Enumeration enumeration = servletConfig.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.put(string, servletConfig.getInitParameter(string));
            }
        }
    }
}

