/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;

public class Resources {
    private static String SERVLET_CONTEXT_PARAM;
    public static String SERVLET_CONTEXT_KEY;
    private static String HTTP_SERVLET_REQUEST_PARAM;
    public static String HTTP_SERVLET_REQUEST_KEY;
    private static String ACTION_MESSAGES_PARAM;
    public static String ACTION_ERRORS_KEY;

    public static ValidatorResources getValidatorResources(ServletContext servletContext, HttpServletRequest httpServletRequest) {
        String string = ModuleUtils.getInstance().getModuleConfig(httpServletRequest, servletContext).getPrefix();
        return (ValidatorResources)servletContext.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + string);
    }

    public static MessageResources getMessageResources(HttpServletRequest httpServletRequest) {
        return (MessageResources)httpServletRequest.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static MessageResources getMessageResources(ServletContext servletContext, HttpServletRequest httpServletRequest, String string) {
        MessageResources messageResources;
        if (string == null) {
            string = "org.apache.struts.action.MESSAGE";
        }
        if ((messageResources = (MessageResources)httpServletRequest.getAttribute(string)) == null) {
            ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(httpServletRequest, servletContext);
            messageResources = (MessageResources)servletContext.getAttribute(string + moduleConfig.getPrefix());
        }
        if (messageResources == null) {
            messageResources = (MessageResources)servletContext.getAttribute(string);
        }
        if (messageResources == null) {
            throw new NullPointerException("No message resources found for bundle: " + string);
        }
        return messageResources;
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest) {
        return RequestUtils.getUserLocale(httpServletRequest, null);
    }

    public static String getMessage(MessageResources messageResources, Locale locale, String string) {
        String string2 = null;
        if (messageResources != null) {
            string2 = messageResources.getMessage(locale, string);
        }
        return string2 == null ? "" : string2;
    }

    public static String getMessage(HttpServletRequest httpServletRequest, String string) {
        MessageResources messageResources = Resources.getMessageResources(httpServletRequest);
        return Resources.getMessage(messageResources, RequestUtils.getUserLocale(httpServletRequest, null), string);
    }

    public static String getMessage(MessageResources messageResources, Locale locale, ValidatorAction validatorAction, Field field) {
        Object[] objectArray = Resources.getArgs(validatorAction.getName(), messageResources, locale, field);
        String string = field.getMsg(validatorAction.getName()) != null ? field.getMsg(validatorAction.getName()) : validatorAction.getMsg();
        return messageResources.getMessage(locale, string, objectArray);
    }

    public static String getMessage(ServletContext servletContext, HttpServletRequest httpServletRequest, MessageResources messageResources, Locale locale, ValidatorAction validatorAction, Field field) {
        Msg msg = field.getMessage(validatorAction.getName());
        if (msg != null && !msg.isResource()) {
            return msg.getKey();
        }
        String string = null;
        String string2 = null;
        MessageResources messageResources2 = messageResources;
        if (msg == null) {
            string = validatorAction.getMsg();
        } else {
            string = msg.getKey();
            string2 = msg.getBundle();
            if (msg.getBundle() != null) {
                messageResources2 = Resources.getMessageResources(servletContext, httpServletRequest, msg.getBundle());
            }
        }
        if (string == null || string.length() == 0) {
            return "??? " + validatorAction.getName() + "." + field.getProperty() + " ???";
        }
        Arg[] argArray = field.getArgs(validatorAction.getName());
        Object[] objectArray = Resources.getArgValues(servletContext, httpServletRequest, messageResources2, locale, argArray);
        return messageResources2.getMessage(locale, string, objectArray);
    }

    public static ActionError getActionError(HttpServletRequest httpServletRequest, ValidatorAction validatorAction, Field field) {
        Object[] objectArray = Resources.getArgs(validatorAction.getName(), Resources.getMessageResources(httpServletRequest), RequestUtils.getUserLocale(httpServletRequest, null), field);
        String string = field.getMsg(validatorAction.getName()) != null ? field.getMsg(validatorAction.getName()) : validatorAction.getMsg();
        return new ActionError(string, objectArray);
    }

    public static ActionMessage getActionMessage(HttpServletRequest httpServletRequest, ValidatorAction validatorAction, Field field) {
        Object[] objectArray = Resources.getArgs(validatorAction.getName(), Resources.getMessageResources(httpServletRequest), RequestUtils.getUserLocale(httpServletRequest, null), field);
        String string = field.getMsg(validatorAction.getName()) != null ? field.getMsg(validatorAction.getName()) : validatorAction.getMsg();
        return new ActionMessage(string, objectArray);
    }

    public static ActionMessage getActionMessage(Validator validator, HttpServletRequest httpServletRequest, ValidatorAction validatorAction, Field field) {
        Msg msg = field.getMessage(validatorAction.getName());
        if (msg != null && !msg.isResource()) {
            return new ActionMessage(msg.getKey(), false);
        }
        String string = null;
        String string2 = null;
        if (msg == null) {
            string = validatorAction.getMsg();
        } else {
            string = msg.getKey();
            string2 = msg.getBundle();
        }
        if (string == null || string.length() == 0) {
            return new ActionMessage("??? " + validatorAction.getName() + "." + field.getProperty() + " ???", false);
        }
        ServletContext servletContext = (ServletContext)validator.getParameterValue(SERVLET_CONTEXT_PARAM);
        MessageResources messageResources = Resources.getMessageResources(servletContext, httpServletRequest, string2);
        Locale locale = RequestUtils.getUserLocale(httpServletRequest, null);
        Arg[] argArray = field.getArgs(validatorAction.getName());
        Object[] objectArray = Resources.getArgValues(servletContext, httpServletRequest, messageResources, locale, argArray);
        ActionMessage actionMessage = null;
        if (string2 == null) {
            actionMessage = new ActionMessage(string, objectArray);
        } else {
            String string3 = messageResources.getMessage(locale, string, objectArray);
            actionMessage = new ActionMessage(string3, false);
        }
        return actionMessage;
    }

    public static String[] getArgs(String string, MessageResources messageResources, Locale locale, Field field) {
        String[] stringArray = new String[4];
        Arg[] argArray = new Arg[]{field.getArg(string, 0), field.getArg(string, 1), field.getArg(string, 2), field.getArg(string, 3)};
        int n = 0;
        while (n < argArray.length) {
            if (argArray[n] != null) {
                stringArray[n] = argArray[n].isResource() ? Resources.getMessage(messageResources, locale, argArray[n].getKey()) : argArray[n].getKey();
            }
            ++n;
        }
        return stringArray;
    }

    private static String[] getArgValues(ServletContext servletContext, HttpServletRequest httpServletRequest, MessageResources messageResources, Locale locale, Arg[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[argArray.length];
        int n = 0;
        while (n < argArray.length) {
            if (argArray[n] != null) {
                if (argArray[n].isResource()) {
                    MessageResources messageResources2 = messageResources;
                    if (argArray[n].getBundle() != null) {
                        messageResources2 = Resources.getMessageResources(servletContext, httpServletRequest, argArray[n].getBundle());
                    }
                    stringArray[n] = messageResources2.getMessage(locale, argArray[n].getKey());
                } else {
                    stringArray[n] = argArray[n].getKey();
                }
            }
            ++n;
        }
        return stringArray;
    }

    public static Validator initValidator(String string, Object object, ServletContext servletContext, HttpServletRequest httpServletRequest, ActionMessages actionMessages, int n) {
        ValidatorResources validatorResources = Resources.getValidatorResources(servletContext, httpServletRequest);
        Locale locale = RequestUtils.getUserLocale(httpServletRequest, null);
        Validator validator = new Validator(validatorResources, string);
        validator.setUseContextClassLoader(true);
        validator.setPage(n);
        validator.setParameter(SERVLET_CONTEXT_PARAM, (Object)servletContext);
        validator.setParameter(HTTP_SERVLET_REQUEST_PARAM, (Object)httpServletRequest);
        validator.setParameter("java.util.Locale", (Object)locale);
        validator.setParameter(ACTION_MESSAGES_PARAM, (Object)actionMessages);
        validator.setParameter("java.lang.Object", object);
        return validator;
    }

    static {
        SERVLET_CONTEXT_KEY = SERVLET_CONTEXT_PARAM = "javax.servlet.ServletContext";
        HTTP_SERVLET_REQUEST_KEY = HTTP_SERVLET_REQUEST_PARAM = "javax.servlet.http.HttpServletRequest";
        ACTION_ERRORS_KEY = ACTION_MESSAGES_PARAM = "org.apache.struts.action.ActionMessages";
    }
}

