/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.apache.commons.digester.plugins.InitializableRule;
import org.apache.commons.digester.plugins.LogUtils;
import org.apache.commons.digester.plugins.PluginConfigurationException;
import org.apache.commons.digester.plugins.PluginContext;
import org.apache.commons.digester.plugins.PluginManager;
import org.apache.commons.logging.Log;

public class PluginRules
implements Rules {
    protected Digester digester = null;
    private Rules decoratedRules;
    private PluginManager pluginManager;
    private String mountPoint = null;
    private PluginRules parent = null;
    private PluginContext pluginContext = null;

    public PluginRules() {
        this(new RulesBase());
    }

    public PluginRules(Rules rules) {
        this.decoratedRules = rules;
        this.pluginContext = new PluginContext();
        this.pluginManager = new PluginManager(this.pluginContext);
    }

    PluginRules(String string, PluginRules pluginRules) {
        this.decoratedRules = new RulesBase();
        this.pluginContext = pluginRules.pluginContext;
        this.pluginManager = new PluginManager(pluginRules.pluginManager);
        this.mountPoint = string;
        this.parent = pluginRules;
    }

    public Rules getParent() {
        return this.parent;
    }

    public Digester getDigester() {
        return this.digester;
    }

    public void setDigester(Digester digester) {
        this.digester = digester;
        this.decoratedRules.setDigester(digester);
    }

    public String getNamespaceURI() {
        return this.decoratedRules.getNamespaceURI();
    }

    public void setNamespaceURI(String string) {
        this.decoratedRules.setNamespaceURI(string);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public List getRuleFinders() {
        return this.pluginContext.getRuleFinders();
    }

    public void setRuleFinders(List list) {
        this.pluginContext.setRuleFinders(list);
    }

    Rules getDecoratedRules() {
        return this.decoratedRules;
    }

    public List rules() {
        return this.decoratedRules.rules();
    }

    public void add(String string, Rule rule) {
        Log log = LogUtils.getLogger(this.digester);
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)("add entry: mapping pattern [" + string + "]" + " to rule of type [" + rule.getClass().getName() + "]"));
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.mountPoint != null && !string.equals(this.mountPoint) && !string.startsWith(this.mountPoint + "/")) {
            log.warn((Object)("An attempt was made to add a rule with a pattern thatis not at or below the mountpoint of the current PluginRules object. Rule pattern: " + string + ", mountpoint: " + this.mountPoint + ", rule type: " + rule.getClass().getName()));
            return;
        }
        this.decoratedRules.add(string, rule);
        if (rule instanceof InitializableRule) {
            try {
                ((InitializableRule)((Object)rule)).postRegisterInit(string);
            }
            catch (PluginConfigurationException pluginConfigurationException) {
                if (bl) {
                    log.debug((Object)"Rule initialisation failed", (Throwable)pluginConfigurationException);
                }
                return;
            }
        }
        if (bl) {
            log.debug((Object)("add exit: mapped pattern [" + string + "]" + " to rule of type [" + rule.getClass().getName() + "]"));
        }
    }

    public void clear() {
        this.decoratedRules.clear();
    }

    public List match(String string) {
        return this.match(null, string);
    }

    public List match(String string, String string2) {
        List list;
        Log log = LogUtils.getLogger(this.digester);
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)("Matching path [" + string2 + "] on rules object " + this.toString()));
        }
        if (this.mountPoint != null && string2.length() <= this.mountPoint.length()) {
            if (bl) {
                log.debug((Object)("Path [" + string2 + "] delegated to parent."));
            }
            list = this.parent.match(string, string2);
        } else {
            list = this.decoratedRules.match(string, string2);
        }
        return list;
    }

    public void setPluginClassAttribute(String string, String string2) {
        this.pluginContext.setPluginClassAttribute(string, string2);
    }

    public void setPluginIdAttribute(String string, String string2) {
        this.pluginContext.setPluginIdAttribute(string, string2);
    }

    public String getPluginClassAttrNs() {
        return this.pluginContext.getPluginClassAttrNs();
    }

    public String getPluginClassAttr() {
        return this.pluginContext.getPluginClassAttr();
    }

    public String getPluginIdAttrNs() {
        return this.pluginContext.getPluginIdAttrNs();
    }

    public String getPluginIdAttr() {
        return this.pluginContext.getPluginIdAttr();
    }
}

